#include "stdafx.h"
#include "win_demo.h"
#include "DialogDiskAlarm.h"
#include "afxdialogex.h"
#include "sdks.h"
#include "common_struct.h"
#include "perser_json.h"
#include "pack_json.h"


extern int m_handle;
extern int m_chn_option;
IMPLEMENT_DYNAMIC(CDialogDiskAlarm, CDialogEx)

CDialogDiskAlarm::CDialogDiskAlarm(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_DISK_ALARM, pParent)
{

}

CDialogDiskAlarm::~CDialogDiskAlarm()
{
}

void CDialogDiskAlarm::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT_ALARM_INTERVAL, m_alarm_interval);
	DDX_Control(pDX, IDC_EDIT_ALARM_THRESHOLD, m_alarm_threshold);
}

jy_dev_disk_alarm_param_list_t disk_alarm_param_list = { 0 };
BOOL CDialogDiskAlarm::OnInitDiskAlarm()
{
	char *p_result = NULL;
	int nRet = 0;
	CString strins;
	nRet = sdks_dev_get_disk_alarm_para(m_handle, m_chn_option, &p_result);
	if (0 == nRet)
	{
		json_perser_disk_alarm(p_result, &disk_alarm_param_list);
		((CButton*)GetDlgItem(IDC_CHECK_DISK_FULL))->SetCheck(0);
		if (disk_alarm_param_list.disk_param_list[0].full_alarm_enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_DISK_FULL))->SetCheck(1);
		}
		((CButton*)GetDlgItem(IDC_CHECK_DISK_ABNORMAL))->SetCheck(0);
		if (disk_alarm_param_list.disk_param_list[0].error_alarm_enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_DISK_ABNORMAL))->SetCheck(1);
		}
		((CButton*)GetDlgItem(IDC_CHECK_NO_DISK))->SetCheck(0);
		if (disk_alarm_param_list.disk_param_list[0].no_disk_alarm_enable)
		{
			((CButton*)GetDlgItem(IDC_CHECK_NO_DISK))->SetCheck(1);
		}
		strins.Format(_T("%d"), disk_alarm_param_list.disk_param_list[0].alarm_interval);
		m_alarm_interval.SetWindowTextA(strins);
		strins.Format(_T("%d"), disk_alarm_param_list.disk_param_list[0].alarm_threshold);
		m_alarm_threshold.SetWindowTextA(strins);
	}
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogDiskAlarm, CDialogEx)
	ON_BN_CLICKED(IDOK, &CDialogDiskAlarm::OnBnClickedOk)
END_MESSAGE_MAP()



void CDialogDiskAlarm::OnBnClickedOk()
{
	CString str_tmp;
	char *p_param = NULL;
	disk_alarm_param_list.disk_param_list[0].full_alarm_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_DISK_FULL))->GetCheck() == TRUE)
	{
		disk_alarm_param_list.disk_param_list[0].full_alarm_enable = 1;
	}
	disk_alarm_param_list.disk_param_list[0].error_alarm_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_DISK_ABNORMAL))->GetCheck() == TRUE)
	{
		disk_alarm_param_list.disk_param_list[0].error_alarm_enable = 1;
	}
	disk_alarm_param_list.disk_param_list[0].no_disk_alarm_enable = 0;
	if (((CButton*)GetDlgItem(IDC_CHECK_NO_DISK))->GetCheck() == TRUE)
	{
		disk_alarm_param_list.disk_param_list[0].no_disk_alarm_enable = 1;
	}
	m_alarm_interval.GetWindowText(str_tmp);
	disk_alarm_param_list.disk_param_list[0].alarm_interval = _ttoi(str_tmp);
	m_alarm_threshold.GetWindowText(str_tmp);
	disk_alarm_param_list.disk_param_list[0].alarm_threshold = _ttoi(str_tmp);
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to set disk alarm?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		pack_json_disk_alarm(&disk_alarm_param_list, &p_param);
		int nRet = sdks_dev_json_set_disk_alarm_para(m_handle, p_param);
		if (nRet) {
			MessageBoxA("Set disk alarm param fail!");
		}
	}
}
